IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES
			 WHERE TABLE_NAME='CG_FND_VERBA_NOTA_CREDITO_GRUPO')
begin
CREATE TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO](
	[CD_CTR_GRUPO] [int] IDENTITY(1,1) NOT NULL,
	[DS_GRUPO] [varchar](150) NOT NULL,
	[CD_USU] [int] NOT NULL,
	[DT_CAD] [datetime] NOT NULL,
	[TP_PARAMETRO] [int] NOT NULL,
	[FLAG_TIPO_GRUPO] [int] NOT NULL,
	[HISTORICO] [varchar](500) NOT NULL,
	[DT_ULT_ALT] [datetime] NULL,
	[VLR_RESSARCIMENTO] [money] NOT NULL,
	[CD_EMP] [int] NOT NULL,
	[CD_FORN] [int] NOT NULL,
 CONSTRAINT [PK_CG_FND_VERBA_NOTA_CREDITO_GRUPO] PRIMARY KEY CLUSTERED 
(
	[CD_CTR_GRUPO] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY],
 CONSTRAINT [IX_CG_FND_VERBA_NOTA_CREDITO_GRUPO] UNIQUE NONCLUSTERED 
(
	[DS_GRUPO] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO] ADD  CONSTRAINT [DF_CG_FND_VERBA_NOTA_CREDITO_GRUPO_DS_GRUPO]  DEFAULT ('') FOR [DS_GRUPO]

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO] ADD  CONSTRAINT [DF_CG_FND_VERBA_NOTA_CREDITO_GRUPO_CD_USU]  DEFAULT ((0)) FOR [CD_USU]

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO] ADD  CONSTRAINT [DF_CG_FND_VERBA_NOTA_CREDITO_GRUPO_TP_REGRESSAO]  DEFAULT ((0)) FOR [TP_PARAMETRO]

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO] ADD  CONSTRAINT [DF_CG_FND_VERBA_NOTA_CREDITO_GRUPO_FLAG_TIPO_GRUPO]  DEFAULT ((0)) FOR [FLAG_TIPO_GRUPO]

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO] ADD  CONSTRAINT [DF_CG_FND_VERBA_NOTA_CREDITO_GRUPO_HISTORICO]  DEFAULT ('') FOR [HISTORICO]

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO] ADD  CONSTRAINT [DF_CG_FND_VERBA_NOTA_CREDITO_GRUPO_VLR_RESSARCIMENTO]  DEFAULT ((0)) FOR [VLR_RESSARCIMENTO]

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO] ADD  CONSTRAINT [DF_CG_FND_VERBA_NOTA_CREDITO_GRUPO_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO] ADD  CONSTRAINT [DF_CG_FND_VERBA_NOTA_CREDITO_GRUPO_CD_FORN]  DEFAULT ((0)) FOR [CD_FORN]

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO]  WITH CHECK ADD  CONSTRAINT [FK_CG_FND_VERBA_NOTA_CREDITO_GRUPO_PG_FORN] FOREIGN KEY([CD_EMP], [CD_FORN])
REFERENCES [dbo].[PG_FORN] ([CD_EMP], [CD_FORN])

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO] CHECK CONSTRAINT [FK_CG_FND_VERBA_NOTA_CREDITO_GRUPO_PG_FORN]
END